/* _inputParameters: an object with different values for the model parameters */
function Doppler_droga01(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog,
    downloadText: EJSS_TOOLS.File.downloadText,
    uploadText: function(action) { EJSS_TOOLS.File.uploadText(_model,action); } 
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var t; // EjsS Model.Variables.Tablica zmiennych.t
  var xs; // EjsS Model.Variables.Tablica zmiennych.xs
  var yc; // EjsS Model.Variables.Tablica zmiennych.yc
  var vs; // EjsS Model.Variables.Tablica zmiennych.vs
  var f0; // EjsS Model.Variables.Tablica zmiennych.f0
  var f; // EjsS Model.Variables.Tablica zmiennych.f
  var vsx; // EjsS Model.Variables.Tablica zmiennych.vsx
  var vsy; // EjsS Model.Variables.Tablica zmiennych.vsy
  var c; // EjsS Model.Variables.Tablica zmiennych.c
  var alfa; // EjsS Model.Variables.Tablica zmiennych.alfa
  var cosa; // EjsS Model.Variables.Tablica zmiennych.cosa
  var sina; // EjsS Model.Variables.Tablica zmiennych.sina
  var vsc; // EjsS Model.Variables.Tablica zmiennych.vsc
  var mnoznik; // EjsS Model.Variables.Tablica zmiennych.mnoznik
  var vn; // EjsS Model.Variables.Tablica zmiennych.vn
  var vnx; // EjsS Model.Variables.Tablica zmiennych.vnx
  var vny; // EjsS Model.Variables.Tablica zmiennych.vny

  var _privateOdesList;
  var _ODEi_evolution1;
  var userEvents1=[];

  _model.getOdes = function() { return [_ODEi_evolution1]; };

  _model.removeEvents = function(){
    userEvents1=[];
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      t : t,
      xs : xs,
      yc : yc,
      vs : vs,
      f0 : f0,
      f : f,
      vsx : vsx,
      vsy : vsy,
      c : c,
      alfa : alfa,
      cosa : cosa,
      sina : sina,
      vsc : vsc,
      mnoznik : mnoznik,
      vn : vn,
      vnx : vnx,
      vny : vny
    };
  };

  function _serializePublic() { return _model.serializePublic(); }

  _model._userSerializePublic = function() {
    return {
      t : t,
      xs : xs,
      yc : yc,
      vs : vs,
      f0 : f0,
      f : f,
      vsx : vsx,
      vsy : vsy,
      c : c,
      alfa : alfa,
      cosa : cosa,
      sina : sina,
      vsc : vsc,
      mnoznik : mnoznik,
      vn : vn,
      vnx : vnx,
      vny : vny
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.xs != "undefined") xs = json.xs;
    if(typeof json.yc != "undefined") yc = json.yc;
    if(typeof json.vs != "undefined") vs = json.vs;
    if(typeof json.f0 != "undefined") f0 = json.f0;
    if(typeof json.f != "undefined") f = json.f;
    if(typeof json.vsx != "undefined") vsx = json.vsx;
    if(typeof json.vsy != "undefined") vsy = json.vsy;
    if(typeof json.c != "undefined") c = json.c;
    if(typeof json.alfa != "undefined") alfa = json.alfa;
    if(typeof json.cosa != "undefined") cosa = json.cosa;
    if(typeof json.sina != "undefined") sina = json.sina;
    if(typeof json.vsc != "undefined") vsc = json.vsc;
    if(typeof json.mnoznik != "undefined") mnoznik = json.mnoznik;
    if(typeof json.vn != "undefined") vn = json.vn;
    if(typeof json.vnx != "undefined") vnx = json.vnx;
    if(typeof json.vny != "undefined") vny = json.vny;
  };

  _model._readParametersPublic = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.xs != "undefined") xs = json.xs;
    if(typeof json.yc != "undefined") yc = json.yc;
    if(typeof json.vs != "undefined") vs = json.vs;
    if(typeof json.f0 != "undefined") f0 = json.f0;
    if(typeof json.f != "undefined") f = json.f;
    if(typeof json.vsx != "undefined") vsx = json.vsx;
    if(typeof json.vsy != "undefined") vsy = json.vsy;
    if(typeof json.c != "undefined") c = json.c;
    if(typeof json.alfa != "undefined") alfa = json.alfa;
    if(typeof json.cosa != "undefined") cosa = json.cosa;
    if(typeof json.sina != "undefined") sina = json.sina;
    if(typeof json.vsc != "undefined") vsc = json.vsc;
    if(typeof json.mnoznik != "undefined") mnoznik = json.mnoznik;
    if(typeof json.vn != "undefined") vn = json.vn;
    if(typeof json.vnx != "undefined") vnx = json.vnx;
    if(typeof json.vny != "undefined") vny = json.vny;
  };

  function _unserializePublic(json) { return _model.unserializePublic(json); }

  _model._userUnserializePublic = function(json) {
    _model._readParametersPublic(json);
   _resetSolvers();
   _model.update();
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    _model._readParameters(json);
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Strona poczštkowa"] = true;
    __pagesEnabled["Strona dzialania"] = true;
    __pagesEnabled["Strona stałych"] = true;
  });

  _model.addToReset(function() {
    t = 0; // EjsS Model.Variables.Tablica zmiennych.t
    xs = -390; // EjsS Model.Variables.Tablica zmiennych.xs
    yc = -150; // EjsS Model.Variables.Tablica zmiennych.yc
    vs = 20; // EjsS Model.Variables.Tablica zmiennych.vs
    f0 = 500; // EjsS Model.Variables.Tablica zmiennych.f0
    c = 100; // EjsS Model.Variables.Tablica zmiennych.c
    alfa = 0; // EjsS Model.Variables.Tablica zmiennych.alfa
    mnoznik = 5; // EjsS Model.Variables.Tablica zmiennych.mnoznik
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Strona poczštkowa"]) return;
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Strona dzialania"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["Strona stałych"]) return;
    cosa=(-xs)/Math.sqrt(xs*xs+yc*yc);  // > FixedRelations.Strona stałych:1
    sina=(yc)/Math.sqrt(xs*xs+yc*yc);  // > FixedRelations.Strona stałych:2
    vsc=vs*cosa;  // > FixedRelations.Strona stałych:3
    vsx=vs*cosa*cosa;  // > FixedRelations.Strona stałych:4
    vsy=vs*cosa*sina;  // > FixedRelations.Strona stałych:5
    f=f0/(1-(vsc/c));  // > FixedRelations.Strona stałych:6
    vn=vs*sina;  // > FixedRelations.Strona stałych:7
    vnx=vs-vsc*cosa;  // > FixedRelations.Strona stałych:8
    vny=vsc*sina;  // > FixedRelations.Strona stałych:9
    if ( xs>400 ) {  // > FixedRelations.Strona stałych:10
      xs=-420;  // > FixedRelations.Strona stałych:11
      _view._initialize();  // > FixedRelations.Strona stałych:12
    }  // > FixedRelations.Strona stałych:13
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  _getODE = function (_odeName) {
    if (_odeName=="Strona dzialania") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.cashKarp45;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf._getOdeVars = function (){ return["xs","t"]};

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(0.05);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      for(k in userEvents1){__eventSolver.addEvent(userEvents1[k]);}
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.00001,0.00001);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=xs) __mustReinitialize = true;
        __state[__cIn++] = xs;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (0.05===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(0.05);
      __eventSolver.setInternalStepSize(0.05);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.00001,0.00001);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        xs = __state[__cOut++];
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var xs = _aState[__cOut++];
        var t = _aState[__cOut++];
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = vs; // Rate for ODE: Strona dzialania:xs
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __odeSelf._addEvent = function(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent){
    var User_Event = function (userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent) {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return eventType; };

      _eventSelf.getRootFindingMethod = function() { return eventMethod; };

      _eventSelf.getMaxIterations = function() { return maxIter; };

      _eventSelf.getTolerance = function() { return eventTolerance; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var xs = _aState[__cOut++];
        var t = _aState[__cOut++];
      return eval(userCondition);
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        xs = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = xs;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        if (undefined != functions) eval(functions.toString());
        eval(userAction);
        return endAtEvent;
      }

      return _eventSelf;
    }; // End of event

   userEvents1.push(User_Event(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent));
   }

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_xs(__time) {
    var __index = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 1024, height : 768 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new Doppler_droga01_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.twoStateButton.setAction("OffClick", _pause); // HtmlView Page setting action 'OffClick' for element 'twoStateButton'
          _view.twoStateButton.setAction("OnClick", _play); // HtmlView Page setting action 'OnClick' for element 'twoStateButton'
          _view.reset.setAction("OnClick", _reset); // HtmlView Page setting action 'OnClick' for element 'reset'
          _view.slider_yc.linkProperty("Value",  function() { return yc; }, function(_v) { yc = _v; } ); // HtmlView Page linking property 'Value' for element 'slider_yc'
          _view.autko.linkProperty("X",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'X' for element 'autko'
          _view.auto.linkProperty("X",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'X' for element 'auto'
          _view.predkosc.linkProperty("SizeX",  function() { return vs*mnoznik; } ); // HtmlView Page linking property 'SizeX' for element 'predkosc'
          _view.predkosc.linkProperty("X",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'X' for element 'predkosc'
          _view.czlowiek.linkProperty("Y",  function() { return yc; }, function(_v) { yc = _v; } ); // HtmlView Page linking property 'Y' for element 'czlowiek'
          _view.v_Dop.linkProperty("SizeX",  function() { return vsx*mnoznik; } ); // HtmlView Page linking property 'SizeX' for element 'v_Dop'
          _view.v_Dop.linkProperty("X",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'X' for element 'v_Dop'
          _view.v_Dop.linkProperty("SizeY",  function() { return vsy*mnoznik; } ); // HtmlView Page linking property 'SizeY' for element 'v_Dop'
          _view.lacznik.linkProperty("SizeX",  function() { return 0-xs; } ); // HtmlView Page linking property 'SizeX' for element 'lacznik'
          _view.lacznik.linkProperty("X",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'X' for element 'lacznik'
          _view.lacznik.linkProperty("SizeY",  function() { return yc; }, function(_v) { yc = _v; } ); // HtmlView Page linking property 'SizeY' for element 'lacznik'
          _view.v_n.linkProperty("SizeX",  function() { return vnx*mnoznik; } ); // HtmlView Page linking property 'SizeX' for element 'v_n'
          _view.v_n.linkProperty("X",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'X' for element 'v_n'
          _view.v_n.linkProperty("SizeY",  function() { return -vny*mnoznik; } ); // HtmlView Page linking property 'SizeY' for element 'v_n'
          _view.v_Doplinia.linkProperty("SizeX",  function() { return vsx*mnoznik; } ); // HtmlView Page linking property 'SizeX' for element 'v_Doplinia'
          _view.v_Doplinia.linkProperty("X",  function() { return xs+vnx*mnoznik; } ); // HtmlView Page linking property 'X' for element 'v_Doplinia'
          _view.v_Doplinia.linkProperty("Y",  function() { return 0-vny*mnoznik; } ); // HtmlView Page linking property 'Y' for element 'v_Doplinia'
          _view.v_Doplinia.linkProperty("SizeY",  function() { return vsy*mnoznik; } ); // HtmlView Page linking property 'SizeY' for element 'v_Doplinia'
          _view.vn_linia.linkProperty("SizeX",  function() { return vnx*mnoznik; } ); // HtmlView Page linking property 'SizeX' for element 'vn_linia'
          _view.vn_linia.linkProperty("X",  function() { return xs+vsx*mnoznik; } ); // HtmlView Page linking property 'X' for element 'vn_linia'
          _view.vn_linia.linkProperty("Y",  function() { return 0+vsy*mnoznik; } ); // HtmlView Page linking property 'Y' for element 'vn_linia'
          _view.vn_linia.linkProperty("SizeY",  function() { return -vny*mnoznik; } ); // HtmlView Page linking property 'SizeY' for element 'vn_linia'
          _view.V.linkProperty("X",  function() { return xs+vs*mnoznik/2; } ); // HtmlView Page linking property 'X' for element 'V'
          _view.VD.linkProperty("X",  function() { return xs+vsx*mnoznik*1.15; } ); // HtmlView Page linking property 'X' for element 'VD'
          _view.VD.linkProperty("Y",  function() { return vsy*mnoznik*1.15; } ); // HtmlView Page linking property 'Y' for element 'VD'
          _view.VN.linkProperty("X",  function() { return xs+vnx*mnoznik*1.15; } ); // HtmlView Page linking property 'X' for element 'VN'
          _view.VN.linkProperty("Y",  function() { return 0-vny*mnoznik*1.15; } ); // HtmlView Page linking property 'Y' for element 'VN'
          _view.ludek.linkProperty("Y",  function() { return yc-15; } ); // HtmlView Page linking property 'Y' for element 'ludek'
          _view.trail.linkProperty("InputX",  function() { return xs; }, function(_v) { xs = _v; } ); // HtmlView Page linking property 'InputX' for element 'trail'
          _view.trail.linkProperty("InputY",  function() { return f; }, function(_v) { f = _v; } ); // HtmlView Page linking property 'InputY' for element 'trail'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function Doppler_droga01_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = Doppler_droga01_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function Doppler_droga01_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"panelG", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'panelG'
      .setProperty("Height",700) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'panelG'
      .setProperty("Width",800) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'panelG'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"panel_menu", _view.panelG) // EJsS HtmlView.HtmlView Page: declaration of element 'panel_menu'
      .setProperty("Height",50) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'panel_menu'
      .setProperty("Width",800) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'panel_menu'
      .setProperty("Background","rgba(230,230,210,1)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'panel_menu'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"lewy", _view.panel_menu) // EJsS HtmlView.HtmlView Page: declaration of element 'lewy'
      .setProperty("Height",50) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'lewy'
      .setProperty("Width",400) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'lewy'
      .setProperty("CSS",{"float":"left"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'lewy'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"twoStateButton", _view.lewy) // EJsS HtmlView.HtmlView Page: declaration of element 'twoStateButton'
      .setProperty("Height",40) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'twoStateButton'
      .setProperty("Width",90) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'twoStateButton'
      .setProperty("TextOn","Start") // EJsS HtmlView.HtmlView Page: setting property 'TextOn' for element 'twoStateButton'
      .setProperty("TextOff","Pauza") // EJsS HtmlView.HtmlView Page: setting property 'TextOff' for element 'twoStateButton'
      .setProperty("Foreground","Green") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'twoStateButton'
      .setProperty("Font","normal normal 20px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'twoStateButton'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label", _view.lewy) // EJsS HtmlView.HtmlView Page: declaration of element 'label'
      .setProperty("Width",20) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'label'
      .setProperty("Text"," ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label'
      ;

    _view._addElement(EJSS_INTERFACE.button,"reset", _view.lewy) // EJsS HtmlView.HtmlView Page: declaration of element 'reset'
      .setProperty("Height",40) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'reset'
      .setProperty("Width",90) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'reset'
      .setProperty("Foreground","Magenta") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'reset'
      .setProperty("Text","reset") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'reset'
      .setProperty("Font","normal normal 20px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'reset'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"prawy", _view.panel_menu) // EJsS HtmlView.HtmlView Page: declaration of element 'prawy'
      .setProperty("Height",50) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'prawy'
      .setProperty("Width",400) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'prawy'
      .setProperty("CSS",{"float":"right"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'prawy'
      .setProperty("Background","Gray") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'prawy'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label2", _view.prawy) // EJsS HtmlView.HtmlView Page: declaration of element 'label2'
      .setProperty("Height",50) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'label2'
      .setProperty("Width",200) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'label2'
      .setProperty("TextAlign","right") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label2'
      .setProperty("Foreground","rgba(255,255,192,1)") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'label2'
      .setProperty("Text","Zmień odległość obserwatora od jezdni") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label2'
      .setProperty("Font","normal normal 18px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label2'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"slider_yc", _view.prawy) // EJsS HtmlView.HtmlView Page: declaration of element 'slider_yc'
      .setProperty("Height",40) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'slider_yc'
      .setProperty("Width",150) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'slider_yc'
      .setProperty("Minimum",-150) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'slider_yc'
      .setProperty("Maximum",0) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'slider_yc'
      .setProperty("Background","Gray") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'slider_yc'
      .setProperty("Foreground","Green") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'slider_yc'
      .setProperty("Step",10) // EJsS HtmlView.HtmlView Page: setting property 'Step' for element 'slider_yc'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"panelLG", _view.panelG) // EJsS HtmlView.HtmlView Page: declaration of element 'panelLG'
      .setProperty("Height",300) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'panelLG'
      .setProperty("Width",800) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'panelLG'
      ;

    _view._addElement(EJSS_DRAWING2D.drawingPanel,"drawingPanel", _view.panelLG) // EJsS HtmlView.HtmlView Page: declaration of element 'drawingPanel'
      .setProperty("Height",300) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'drawingPanel'
      .setProperty("Width",800) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'drawingPanel'
      .setProperty("MinimumX",-400) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'drawingPanel'
      .setProperty("MinimumY",-200) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'drawingPanel'
      .setProperty("Background","rgba(202,255,168,1)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'drawingPanel'
      .setProperty("MaximumY",100) // EJsS HtmlView.HtmlView Page: setting property 'MaximumY' for element 'drawingPanel'
      .setProperty("MaximumX",400) // EJsS HtmlView.HtmlView Page: setting property 'MaximumX' for element 'drawingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"droga1", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'droga1'
      .setProperty("FillColor","LightGray") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'droga1'
      .setProperty("SizeX",800) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'droga1'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'droga1'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'droga1'
      .setProperty("Y",10) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'droga1'
      .setProperty("SizeY",40) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'droga1'
      ;

    _view._addElement(EJSS_DRAWING2D.segment,"droga", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'droga'
      .setProperty("SizeX",800) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'droga'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'droga'
      .setProperty("LineColor","White") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'droga'
      .setProperty("Y",10) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'droga'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'droga'
      .setProperty("LineWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'droga'
      .setProperty("Offset","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'Offset' for element 'droga'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"autko", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'autko'
      .setProperty("SizeX",40) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'autko'
      .setProperty("ImageUrl","./autko2.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'autko'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'autko'
      .setProperty("SizeY",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'autko'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"auto", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'auto'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'auto'
      .setProperty("SizeX",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'auto'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'auto'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'auto'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'auto'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'auto'
      .setProperty("SizeY",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'auto'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"predkosc", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'predkosc'
      .setProperty("LineColor","Green") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'predkosc'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'predkosc'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'predkosc'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'predkosc'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"czlowiek", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'czlowiek'
      .setProperty("FillColor","Green") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'czlowiek'
      .setProperty("SizeX",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'czlowiek'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'czlowiek'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'czlowiek'
      .setProperty("SizeY",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'czlowiek'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"v_Dop", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'v_Dop'
      .setProperty("LineColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'v_Dop'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'v_Dop'
      .setProperty("LineWidth",3) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'v_Dop'
      .setProperty("Offset","SOUTH_WEST") // EJsS HtmlView.HtmlView Page: setting property 'Offset' for element 'v_Dop'
      ;

    _view._addElement(EJSS_DRAWING2D.segment,"lacznik", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'lacznik'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'lacznik'
      .setProperty("LineWidth",0.5) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'lacznik'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"v_n", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'v_n'
      .setProperty("LineColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'v_n'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'v_n'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'v_n'
      ;

    _view._addElement(EJSS_DRAWING2D.segment,"v_Doplinia", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'v_Doplinia'
      .setProperty("LineWidth",0.5) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'v_Doplinia'
      ;

    _view._addElement(EJSS_DRAWING2D.segment,"vn_linia", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'vn_linia'
      .setProperty("LineWidth",0.5) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'vn_linia'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"V", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'V'
      .setProperty("FillColor","Green") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'V'
      .setProperty("RelativePosition","SOUTH") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'V'
      .setProperty("Y",5) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'V'
      .setProperty("Text","V") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'V'
      .setProperty("Font","italic normal 13px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'V'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"VD", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'VD'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'VD'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'VD'
      .setProperty("Text","VD") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'VD'
      .setProperty("Font","italic bold 13px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'VD'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"VN", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'VN'
      .setProperty("FillColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'VN'
      .setProperty("Text","Vn") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'VN'
      .setProperty("Font","italic bold 13px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'VN'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"ludek", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'ludek'
      .setProperty("SizeX",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'ludek'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'ludek'
      .setProperty("ImageUrl","./ludek.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'ludek'
      .setProperty("SizeY",45) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'ludek'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"at", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'at'
      .setProperty("RelativePosition","SOUTH_EAST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'at'
      .setProperty("X",360) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'at'
      .setProperty("Y",-180) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'at'
      .setProperty("Text","M Krasiński (2018)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'at'
      .setProperty("Font","italic normal 16px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'at'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"panelLD", _view.panelG) // EJsS HtmlView.HtmlView Page: declaration of element 'panelLD'
      .setProperty("Height",350) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'panelLD'
      .setProperty("Width",800) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'panelLD'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.panelLD) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Height",350) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'plottingPanel'
      .setProperty("Width",800) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'plottingPanel'
      .setProperty("YScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'YScalePrecision' for element 'plottingPanel'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("AxisYFont","normal normal 14px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'AxisYFont' for element 'plottingPanel'
      .setProperty("YFixedTick",1000) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("XTickStep",100) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",50) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("TitleColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'TitleColor' for element 'plottingPanel'
      .setProperty("TitleYFont","normal normal 16px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'TitleYFont' for element 'plottingPanel'
      .setProperty("TitleXFont","normal normal 16px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'TitleXFont' for element 'plottingPanel'
      .setProperty("Title","Słyszana częstotliwość f w funkcji położenia x") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("MaximumY",650) // EJsS HtmlView.HtmlView Page: setting property 'MaximumY' for element 'plottingPanel'
      .setProperty("MaximumX",380) // EJsS HtmlView.HtmlView Page: setting property 'MaximumX' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("MinimumX",-380) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'plottingPanel'
      .setProperty("MinimumY",350) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'plottingPanel'
      .setProperty("TitleY","częstotliwość f (Hz)") // EJsS HtmlView.HtmlView Page: setting property 'TitleY' for element 'plottingPanel'
      .setProperty("AxisXFont","normal normal 14px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'AxisXFont' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("TitleX","położenie x (m)") // EJsS HtmlView.HtmlView Page: setting property 'TitleX' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      .setProperty("TitleFont","normal normal 20px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'TitleFont' for element 'plottingPanel'
      .setProperty("GuttersColor","rgba(230,230,210,1)") // EJsS HtmlView.HtmlView Page: setting property 'GuttersColor' for element 'plottingPanel'
      .setProperty("XScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'XScalePrecision' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.trail,"trail", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'trail'
      .setProperty("LineColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'trail'
      .setProperty("NoRepeat",true) // EJsS HtmlView.HtmlView Page: setting property 'NoRepeat' for element 'trail'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'trail'
      ;

    _view._addElement(EJSS_DRAWING2D.segment,"segment", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'segment'
      .setProperty("SizeX",800) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'segment'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'segment'
      .setProperty("LineColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'segment'
      .setProperty("Y",500) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'segment'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'segment'
      .setProperty("LineWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'segment'
      .setProperty("Offset","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'Offset' for element 'segment'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"text", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'text'
      .setProperty("FillColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'text'
      .setProperty("X",360) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'text'
      .setProperty("Y",485) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'text'
      .setProperty("Text","fo") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'text'
      .setProperty("Font","italic normal 18px Arial, Helvetica, sans-serif") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'text'
      ;

  };

  return _view;
}



      var _model;
      var _scorm;
      window.addEventListener('load',
        function () { 
          _model =  new Doppler_droga01("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
